
jQuery(function()
{
      jQuery('section [href^="#"]').click(function (e) {
      e.preventDefault()
    });
    
    jQuery(".btn-delete").click(function(event)
    {
        return confirm("Are you sure you want to procced?");
    });
    
    jQuery('.tooltip-box').tooltip({
      selector: "a[rel=tooltip]",
      delay: { show: 0, hide: 0 } 
    });
     
    //We don't want jQuery buttons!
    var options = {
        buttons: {}
    };
    jQuery('.body button').button("destroy");
    
});

/****************************
 *          PAGINATION
 *****************************/

/**
 * Get paginaton and insert it!
 **/
function getPagination(parent)
{
    $.get(document.location, "ajax=1&pagination=1&get=1&parent="+parent, function(data){
        form = $("form.pagination input[name$=\"parent\"][value$=\""+parent+"\"]").parents("div.pagination");
        $(form).html(data);
        $("div.pagination a").click(onClickPagination);
    });
}

function resetPagination(parent)
{
    
}

function onClickPagination(event)
{
    event.preventDefault();
    if($(this).parent().hasClass('disabled'))
    {
        return;
    }

    href = $(this).attr("href");
    href = href.substring(1);
    vars = href.split('&');
    parent = vars[1].split('=');
    parent = parent[1];
    pagination = $(this).parents().find('div.pagination');

    $.get(document.location, "ajax=1&pagination=1&"+href, function(data)
    {
        $("#"+parent+" tbody").html(data);
        getPagination(parent);
    });
}




/****************************
 *          FILTERING
 ***************************/
function enableFiltering()
{
    form = $(this).parents('form.filtering');
    parent = $(form).children("input[name$=\"parent\"]").val();
    
    $(this).addClass("hide");
    $(form).children(".disable-filtering").removeClass("hide");
    
    $("form.filtering-options input[name$=\"parent\"][value$=\""+parent+"\"]").parents('.filtering-options').parent().parent().removeClass("hide");
}

function disableFiltering()
{
    form = $(this).parents('form.filtering');
    parent = $(form).children("input[name$=\"parent\"]").val()
    
    $(this).parent().children(".enable-filtering").removeClass("hide");
    $(this).addClass("hide");
    $(this).parent().parent().next().addClass("hide");
    
    resetFiltering(parent);
    getPagination(parent)
}


/**
 * Disable filtering and get new content!
 **/
function resetFiltering(parent)
{
   $.get(document.location, "ajax=1&pagination=1&reset=1&parent="+parent, function(data){
        $("#"+parent).html(data);
    }); 
}

function addKeyPressEvent()
{
    var timeout_id = 0;
    
    parent = $(this).parents(".filtering-options");
    parent_name = $(parent).find('input[name$="parent"]').val();
    clearTimeout(timeout_id);
    timeout_id = setTimeout(function(){
        $.get(document.location, "ajax=1&pagination=1&"+$(parent).serialize(), function(data){
            $("#"+parent_name+" tbody").html(data);
            getPagination(parent_name)
            addPagination();
        });
    }, 500);
}

function enableOrderBy(event)
{
    parent = $(this).parents('table.pagination').attr('id');
    event.preventDefault();
    href = $(this).attr("href");
    order_by = href.substring(1);

    $.get(document.location, "ajax=1&pagination=1&order_by="+order_by+"&parent="+parent, function(data)
    {
        $("#"+parent+" tbody").html(data);
    });
}

function registerConfigOptionEvents(){
    $('select[name="relation[0][product_id]"]').change(function(){
        var $that = $(this);
        if ($that.val() != '' && $('select[name="relation[0][productb_id]"]').val() != ''){
            loadConfigurableOptions($that.val(), $('select[name="relation[0][productb_id]"]').val(), 0);
        }
    });
    $('select[name="relation[0][productb_id]"]').change(function(){
        var $that = $(this);
        if ($that.val() != '' && $('select[name="relation[0][product_id]"]').val() != ''){
            loadConfigurableOptions($('select[name="relation[0][product_id]"]').val(),$that.val(), 0);
        }
    });
}

function registerExistingConfigOptionEvents(){
    $('select[data-type="product"]').change(function(){
        var $that = $(this);
        var $thatb = $that.parent().parent().parent().find('select[data-type="productb"][data-id="'+$that.data('id')+'"]') ;
        if ($that.val() != '' && $thatb.val() != ''){
            loadConfigurableOptions($that.val(),  $thatb.val(), $that.data('id') );
        }
    });
    $('select[data-type="productb"]').change(function(){
        var $thatb = $(this);
        var $that = $thatb.parent().parent().parent().find('select[data-type="product"][data-id="'+$thatb.data('id')+'"]') ;
        if ($that.val() != '' && $thatb.val() != ''){
            loadConfigurableOptions($that.val(),  $thatb.val(), $that.data('id') );
        }
    });
}


function loadConfigurableOptions($p1, $p2, $relid){
    $.ajax({
        type: 'POST',
        url: 'addonmodules.php?module=productlinker&modpage=product&modsubpage=configopt',
        dataType:'json',
        data: {p1: $p1, p2: $p2}
    }).done(function(result){
        if ($relid > 0){
            var $div = $('div[data-id="'+$relid+'"]');
        } else {
            var $div = $('#rel0'); 
            $relid = 0;
        }
        $div.empty();
        $.each(result, function(index, value){
            if (value.id != null){
                $div.append($('<input type="checkbox" value="'+value.id+'" name="relation['+$relid+'][configopt][]"/>&nbsp;<span>'+value.name+'</span><br/>'));   
            }
        });
    });
}
function getParameterValueFromUrl(name, url){
    name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
    var regexS = "[\\?&]"+name+"=([^&#]*)";
    var regex = new RegExp( regexS );
    var results = regex.exec( url );
    if( results == null )
        return null;
    else
        return results[1];
}
function getFileNameFromPath(path) {
    var ary = path.split("/");
    return ary[ary.length - 1];
}

$(function()
{

    var pathname    = window.location.pathname;
    var href        = window.location.href;

    //console.log(href);


    //INVOICE PAGE
    
    //FIND PAGINATION AND ADD EVENTS
    $("div.pagination a").click(onClickPagination);
    
    //BIND KEY PRESS EVENT FOR FILTERING
    $(".filtering-options input").keypress(addKeyPressEvent);
    
    //BIND TABLE HEADER
    $("table.pagination thead a").click(enableOrderBy);


    if (getParameterValueFromUrl('modpage', href) == 'product' ){




        registerConfigOptionEvents();
        registerExistingConfigOptionEvents();
    }





    /*$("table.pagination").each(function(){
        parent = $(this).attr("id");
        $.get(document.location, "ajax=1&pagination=1&parent="+parent+"&"+$(this).serialize(), function(data){
        $("#"+parent).find('.next').attr("disabled", "disabled");
        $("#"+parent).find('.prev').attr("disabled", "disabled");

        $("#"+parent).find('tbody').html(data);

        $.get(document.location, "ajax=1&pagination=1&parent="+parent+"&check=1", function(data){
            if(data.next)
            {
                $("#"+parent).find('.next').removeAttr("disabled");
            }
            else
            {
                $("#"+parent).find('.next').attr("disabled", "disabled");
            }

            if(data.prev)
            {
                $("#"+parent).find('.prev').removeAttr("disabled");
            }
            else
            {
                $("#"+parent).find('.prev').attr("disabled", "disabled");
            }
        },"json");
    })
        
    });*/
    

    
    /*$("form.pagination").submit(function(event){
        event.preventDefault();
        parent = $(this).parents('table.pagination').attr("id");
        
        $.get(document.location, "ajax=1&pagination=1&parent="+parent+"&"+$(this).serialize(), function(data){
            $("#"+parent).find('.next').attr("disabled", "disabled");
            $("#"+parent).find('.prev').attr("disabled", "disabled");
            
            $("#"+parent).find('tbody').html(data);
            
            $.get(document.location, "ajax=1&pagination=1&parent="+parent+"&check=1", function(data){
                if(data.next)
                {
                    $("#"+parent).find('.next').removeAttr("disabled");
                }
                else
                {
                    $("#"+parent).find('.next').attr("disabled", "disabled");
                }
                
                if(data.prev)
                {
                    $("#"+parent).find('.prev').removeAttr("disabled");
                }
                else
                {
                    $("#"+parent).find('.prev').attr("disabled", "disabled");
                }
            },"json");
        })
    });*/
    
    
});
